//______________________________________________________________________________

//            Hlavikov soubor knihovny Tmu1052.dll verze 2.04

//                Copyright (c) 1998-2014 TEDIA spol. s r.o.
//______________________________________________________________________________

unit Tmu1052;

interface
uses Windows, Classes, SysUtils, Wintypes;

//______________________________________________________________ NVRATOV A CHYBOV KDY

//   0      V podku
//   1      Chybn komunikan rychlost
//   2      (rezervovno)
//   3      Chyba pi vysln zprvy
//   4      Timeout - nepila dn odpov
//   5      Timeout - nepila sprvn odpov
//   6      Odpov peruena
//   7      Chyba parity odpovdi
//   8      Chybn hlavika odpovdi
//   9      Chyba CRC odpovdi
//  10      Nelze vytvoit datovou strukturu knihovny
//  11      Neplatn handle zazen
//  12      Chyba spojen s modulem MU-1052
//  13      Chyba pstupu na s

//______________________________________________________________ DATOV TYPY

type
  TPar   = array[0..15] of DWord;   // pole DWord (16 prvku)
  PTPar  = ^TPar;                   // ukazatel na pole DWord
  TBuff  = array[0..99] of DWord;   // pole DWord (100 prvku)
  PTBuff = ^TBuff;                  // ukazatel na pole DWord


//______________________________________________________________ EXPORTOVAN FCE

// Vechny funkce vrac hodnotu 0 (DWord) v ppad spnho proveden.
// Nenulov hodnota signalizuje chybu, pro jej identifikaci lze pout
// funkci TMU1052_Error.




//............................................................. TMU1052_Version

// Vrac verzi knihovny DLL (nutno vydlit 100, nap. vrcen hodnota 100
// znamen verzi 1.00).
// Parametry funkce:
//  Ver - ukazatel na DWord

function TMU1052_Version(Ver:PDWord):DWord; stdcall;




//............................................................. TMU1052_Init

// Inicializuje knihovnu, vyhled a oteve modul MU-1052.
// Pole inicializanch parametr (TPar):
// Par[0] - ukazatel na IP adresu (PChar)
// Par[1] - UDP port (DWord)
// Par[2] - UDP timeout (DWord)
// Par[3..15] - rezerva
// Nastav default komunikan parametry (9600Bd, timeout 100ms, 2 opakovn
// pi chyb). Vrac handle otevenho zazen.
// Parametry funkce:
//  PHNDL - ukazatel na DWord
//  PPar - ukazatel na pole TPar

function TMU1052_Init(PHNDL:PDWord; PPar:PTPar):DWord; stdcall;




//............................................................. TMU1052_SetConfig

// Nastav komunikan rychlost, timeout a opakovn pro komunikaci
// s moduly MicroUnit. Povolen rychlosti odpovdaj modulm MicroUnit,
// tj. 600Bd, 1200Bd, 2400Bd, 4800Bd, 9600Bd, 19200Bd, 38400Bd, 57600Bd
// a 115200Bd. Timeout, tj. max. doba ekn na zahjen odpovdi modulu,
// je nastaviteln od 1 do 65535ms. Opakovn uruje poet zopakovanch voln
// na modul MicroUnit v ppad chybn komunikace, tzn. nap. pro Opakovani=2
// je na modul MicroUnit volno v ppad chyby komunikace celkem 3x.
// Pokud vyhov default hodnoty konfigurace (viz. TMU1052_Init), nen nutno
// tuto funkci volat.
// Parametry funkce:
//  HNDL - DWord s pidlenm handle zazen
//  Baud,Timeout,Opakovani - DWord s nastavenm komunikanch parametr

function TMU1052_SetConfig(HNDL:DWord;Baud,Timeout,Opakovani:DWord):DWord; stdcall;




//............................................................. TMU1052_GetConfig

// Vrac nastavenou komunikan rychlost, timeout a opakovn pro komunikaci
// s moduly MicroUnit.
// Parametry funkce:
//  HNDL - DWord s pidlenm handle zazen
//  Baud,Timeout,Opakovani - ukazatel na DWord s nastavenmi komunikanmi parametry

function TMU1052_GetConfig(HNDL:DWord; Baud,Timeout,Opakovani:PDWord):DWord; stdcall;




//............................................................. TMU1052_Send

// Vyle dotaz (TBuff) na modul MicroUnit, vrt odpov modulu (RBuff),
// Status registr modulu (StatusR) a Status pjmu (StatusP).
// TBuff a RBuff jsou pole obsahujc vyslanou resp. pijatou zprvu.
// Obsah TBuff odpovd vyslan zprv protokolu AIBus-2, bez CRC. Pesn
// vznam je uveden v popisu protokolu.
//  TBuff[0] - adresa volanho modulu MicroUnit (0-255)
//  TBuff[1] - poadovan funkce AIBus-2 (0,1,2,3,100,101,102,103,200)
//  TBuff[2] - poadovan periferie modulu MicroUnit (0-255)
//  TBuff[3] - pm povel (0)
//  TBuff[4] - D1 datov byte dotazu (0-255)
//  TBuff[5] - D2 datov byte dotazu (0-255)
//  TBuff[6] - D3 datov byte dotazu (0-255)
//  TBuff[7] - D4 datov byte dotazu (0-255)
// Pole RBuff obsahuje pouze pijat datov byty odpovdi.
//  RBuff[0] - D1 datov byte odpovdi (0-255)
//  RBuff[1] - D2 datov byte odpovdi (0-255)
//  RBuff[2] - D3 datov byte odpovdi (0-255)
//  RBuff[3] - D4 datov byte odpovdi (0-255)
// StatusR obsahuje pijat Status registr modulu.
// Ve StatusP je uloen kd spnosti komunikace s modulem MicroUnit.
// Slovn popis kdu lze zskat pomoc funkce TMU1052_Error.
// Parametry funkce:
//  HNDL - DWord s pidlenm handle zazen
//  TBuff,RBuff - ukazatele na pole
//  StatusR,StatusP - ukazatele na DWord

function TMU1052_Send(HNDL:DWord;BuffT,BuffR:PTBuff;StatusR,StatusP:PDWord):DWord; stdcall;




//............................................................. TMU1052_Done

// Uzavre otevren zarzen a uvoln knihovnu z pameti.
// Parametry funkce:
//  PHNDL - ukazatel na DWord s pridelenm handle zarzen

function TMU1052_Done(PHNDL:PDWord):DWord; stdcall;




//............................................................. TMU1052_Error

// Prevede nvratov kd na text.
// Parametry funkce:
//  ErrCode - DWord
//  ErrText - ukazatel na pole ErrText

function TMU1052_Error(ErrCode:DWord; ErrText:PTBuff):DWord; stdcall;


//________________________________________________________________ IMPLEMENTACE

implementation

//______________________________________________________________________________

function TMU1052_Version;                             external 'Tmu1052.dll';
function TMU1052_Init;                                external 'Tmu1052.dll';
function TMU1052_SetConfig;                           external 'Tmu1052.dll';
function TMU1052_GetConfig;                           external 'Tmu1052.dll';
function TMU1052_Send;                                external 'Tmu1052.dll';
function TMU1052_Done;                                external 'Tmu1052.dll';
function TMU1052_Error;                               external 'Tmu1052.dll';

//______________________________________________________________________________

begin
end.


