//______________________________________________________________________________

//            Hlavikov soubor knihovny Tmu1052.dll verze 2.04

//                Copyright (c) 1998-2014 TEDIA spol. s r.o.
//______________________________________________________________________________


#ifndef TMU1052_H_INCLUDED
#define TMU1052_H_INCLUDED


#if BUILDING_DLL
# define DLLIMPORT __declspec (dllexport)
#else /* Not BUILDING_DLL */
# define DLLIMPORT __declspec (dllimport)
#endif /* Not BUILDING_DLL */

#ifdef __cplusplus
extern "C" {
#endif

//______________________________________________________________ NVRATOV A CHYBOV KDY

//   0      V podku
//   1      Chybn komunikan rychlost
//   2      (rezervovno)
//   3      Chyba pi vysln zprvy
//   4      Timeout - nepila dn odpov
//   5      Timeout - nepila sprvn odpov
//   6      Odpov peruena
//   7      Chyba parity odpovdi
//   8      Chybn hlavika odpovdi
//   9      Chyba CRC odpovdi
//  10      Nelze vytvoit datovou strukturu knihovny
//  11      Neplatn handle zazen
//  12      Chyba spojen s modulem MU-1052
//  13      Chyba pstupu na s

//______________________________________________________________ DATOV TYPY

extern uint32_t Par[16];	// pole parametr fc TMU1052_Init 
extern uint32_t BuffT[100];	// odeslan dotaz (dotaz protokolu AIBus-2)
extern uint32_t BuffR[100];	// data z pijat odpovdi (pouze data bez hlaviky)
extern uint32_t ErrText[100];	// pole chybovho textu fce TMU1052_Error


//______________________________________________________________ EXPORTOVAN FCE

// Vechny funkce vrac hodnotu 0 (uint32_t) v ppad spnho proveden.
// Nenulov hodnota signalizuje chybu, pro jej identifikaci lze pout
// funkci TMU1052_Error.




//............................................................. TMU1052_Version

// Vrac verzi knihovny DLL (nutno vydlit 100, nap. vrcen hodnota 100
// znamen verzi 1.00).
// Parametry funkce:
//  Ver - ukazatel na uint32_t

DLLIMPORT __stdcall uint32_t TMU1052_Version(uint32_t *Ver);




//............................................................. TMU1052_Init

// Inicializuje knihovnu, vyhled a oteve modul MU-1052.
// Pole inicializanch parametr:
// Par[0] - ukazatel na IP adresu (PChar)
// Par[1] - UDP port (uint32_t)
// Par[2] - UDP timeout (uint32_t)
// Par[3..15] - rezerva
// Nastav default komunikan parametry (9600Bd, timeout 100ms, 2 opakovn
// pi chyb). Vrac handle otevenho zazen.
// Parametry funkce:
//  PHNDL - ukazatel na uint32_t
//  Par - ukazatel na pole Par

DLLIMPORT __stdcall uint32_t TMU1052_Init(uint32_t *PHNDL, uint32_t *Par);




//............................................................. TMU1052_SetConfig

// Nastav komunikan rychlost, timeout a opakovn pro komunikaci
// s moduly MicroUnit. Povolen rychlosti odpovdaj modulm MicroUnit,
// tj. 600Bd, 1200Bd, 2400Bd, 4800Bd, 9600Bd, 19200Bd, 38400Bd, 57600Bd
// a 115200Bd. Timeout, tj. max. doba ekn na zahjen odpovdi modulu,
// je nastaviteln od 1 do 65535ms. Opakovn uruje poet zopakovanch voln
// na modul MicroUnit v ppad chybn komunikace, tzn. nap. pro Opakovani=2
// je na modul MicroUnit volno v ppad chyby komunikace celkem 3x.
// Pokud vyhov default hodnoty konfigurace (viz. TMU1052_Init), nen nutno
// tuto funkci volat.
// Parametry funkce:
//  HNDL - uint32_t s pidlenm handle zazen
//  Baud,Timeout,Opakovani - uint32_t s nastavenm komunikanch parametr

DLLIMPORT __stdcall uint32_t TMU1052_SetConfig(uint32_t HNDL, uint32_t Baud, uint32_t Timeout, uint32_t Opakovani);




//............................................................. TMU1052_GetConfig

// Vrac nastavenou komunikan rychlost, timeout a opakovn pro komunikaci
// s moduly MicroUnit.
// Parametry funkce:
//  HNDL - uint32_t s pidlenm handle zazen
//  Baud,Timeout,Opakovani - ukazatel na uint32_t s nastavenmi komunikanmi parametry

DLLIMPORT __stdcall uint32_t TMU1052_GetConfig(uint32_t HNDL, uint32_t *Baud, uint32_t *Timeout, uint32_t *Opakovani);




//............................................................. TMU1052_Send

// Vyle dotaz (BuffT) na modul MicroUnit, vrt odpov modulu (BuffR),
// Status registr modulu (StatusR) a Status pjmu (StatusP).
// BuffT a BuffR jsou pole obsahujc vyslanou resp. pijatou zprvu.
// Obsah BuffT odpovd vyslan zprv protokolu AIBus-2, bez CRC. Pesn
// vznam je uveden v popisu protokolu.
//  BuffT[0] - adresa volanho modulu MicroUnit (0-255)
//  BuffT[1] - poadovan funkce AIBus-2 (0,1,2,3,100,101,102,103,200)
//  BuffT[2] - poadovan periferie modulu MicroUnit (0-255)
//  BuffT[3] - pm povel (0)
//  BuffT[4] - D1 datov byte dotazu (0-255)
//  BuffT[5] - D2 datov byte dotazu (0-255)
//  BuffT[6] - D3 datov byte dotazu (0-255)
//  BuffT[7] - D4 datov byte dotazu (0-255)
// Pole RBuff obsahuje pouze pijat datov byty odpovdi.
//  BuffR[0] - D1 datov byte odpovdi (0-255)
//  BuffR[1] - D2 datov byte odpovdi (0-255)
//  BuffR[2] - D3 datov byte odpovdi (0-255)
//  BuffR[3] - D4 datov byte odpovdi (0-255)
// StatusR obsahuje pijat Status registr modulu.
// Ve StatusP je uloen kd spnosti komunikace s modulem MicroUnit.
// Slovn popis kdu lze zskat pomoc funkce TMU1052_Error.
// Parametry funkce:
//  HNDL - uint32_t s pidlenm handle zazen
//  BuffT,BuffR - ukazatele na pole
//  StatusR,StatusP - ukazatele na uint32_t

DLLIMPORT __stdcall uint32_t TMU1052_Send(uint32_t HNDL, uint32_t *BuffT, uint32_t *BuffR, uint32_t *StatusR, uint32_t *StatusP);




//............................................................. TMU1052_Done

// Uzave oteven zazen a uvoln knihovnu z pamti.
// Parametry funkce:
//  PHNDL - ukazatel na uint32_t s pidlenm handle zazen

DLLIMPORT __stdcall uint32_t TMU1052_Done(uint32_t *PHNDL);




//............................................................. TMU1052_Error

// Pevede nvratov kd na text.
// Parametry funkce:
//  ErrCode - uint32_t
//  ErrText - ukazatel na pole ErrText

DLLIMPORT __stdcall uint32_t TMU1052_Error(uint32_t ErrCode, uint32_t *ErrText);


//______________________________________________________________________________


#ifdef __cplusplus
}
#endif


#endif // TMU1052_H_INCLUDED
