//______________________________________________________________________________

//                   Pklad pouit knihovny Tmu1052.dll

//                Copyright (c) 1998-2014 TEDIA spol. s r.o.
//______________________________________________________________________________

// Program demonstruje voln jednotlivch funkc knihovny TMU1052 pro
// komunikaci s modulem MicroUnit pes modul MU-1052 resp. MU-1052U.
// Pro pouit knihovny je nutn znalost modulu MicroUnit v rozsahu jeho
// Uivatelsk pruky (implementace periferi u danho modulu).
// Knihovnu nen nutno samostatn instalovat, sta ji v rmci instalace
// aplikanho software pouze pekoprovat do msta, kam bude mt aplikan
// program nastavenu cestu.

//______________________________________________________________________________


unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ComCtrls, StdCtrls, Tmu1052, ExtCtrls;

const
  cAdresaMU    = 1;                // adresa pipojenho modulu MicroUnit k MU-1052
  cBaudMU      = 9600;             // rychlost pipojenho modulu MicroUnit k MU-1052
  cTimeoutMU   = 100;              // [ms] timeout ekn na odpov modulu MicroUnit
  cOpakovaniMU = 2;                // poet opakovanch dotaz pi chyb komunikace

  cAdresaIP    = '192.168.0.99';   // IP adresa modulu MU-1052
  cPortUDP     = 5000;             // UDP port modulu MU-1052
  cTimeoutUDP  = 1000;             // [ms] doba ekn na odpov MU-1052

type
  TForm1 = class(TForm)
    StatusBar1: TStatusBar;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    Label8: TLabel;
    Label9: TLabel;
    Label10: TLabel;
    Label11: TLabel;
    Label12: TLabel;
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1 : TForm1;

implementation

{$R *.dfm}


//______________________________________________________________________________ Pomocn funkce


//_________________________________________________________ Pevod hodnoty DWord

// Funkce pro pevod pijat zprvy na selnou hodnotu. Vstupem je pijat
// datov st odpovdi modulu MicroUnit, vstupem je spotan DWord hodnota.

Function PrevodAIBusDWord(D1,D2,D3,D4:DWord) : DWord;
var
  C1 : DWord;
begin
  C1:=D4;
  C1:=C1*256+D3;
  C1:=C1*256+D2;
  C1:=C1*256+D1;
  Result:=C1;
end;

//________________________________________________________ Pevod hodnoty Double

// Funkce pro pevod pijat zprvy na hodnotu real. Vstupem je pijat
// datov st odpovdi modulu MicroUnit, vstupem je spotan real hodnota.

Function PrevodAIBusDouble(D1,D2,D3,D4:DWord) : double;
var
  I,Exp : byte;
  R     : double;
begin
  R:=(D3 and $7F)*1.0;
  R:=(R*256.0+D2)*256.0+D1;
  if D3>127 then R:=-R;
  Exp:=D4 and $7F;
  if Exp>0 then
    for I:=1 to Exp do R:=R/10.0;
  Result:=R;
end;

//________________________________________________________ Pevod pole na string

// Funkce pro pevod pole typu Buff na string. Vstupem je text ve form pole,
// vstupem je text ve form stringu.

function PrevodTextError(B:TBuff):string;
var
  S : string;
  I : integer;
begin
  I:=0;
  repeat
    if (B[I]<>0) then S:=S+chr(B[I]);
    inc(I);
  until ((I>99) or (B[I]=0));
  Result:=S;
end;

//______________________________________________________________________________ Start programu

// Inicializace zazen. Funkce TMU1052_Init se provd vdy na zatku
// innosti se zazenm. Parametrem je ukazatel na DWord, ve kterm funkce
// vrac handle pidlen zazen a ukazatel na pole 16 DWord s inicializanmi
// sovmi parametry knihovny (IP adresa, port a timeout).

// Zpis konfiguranch dat knihovny. Pomoc funkce TMU1052_SetConfig jsou
// do oteven knihovny zapsny konfiguran data. Parametry jsou handle
// zazen (HNDL), komunikan rychlost (Baud), timeout odpovdi modulu
// MicroUnit (Timeout) a poet opakovn voln (Opakovani), ve typu DWord.

// Komunikace s modulem MicroUnit. Po oteven a ppadnm nastaven
// konfiguranch dat probh komunikace s moduly MicroUnit pomoc funkce
// TMU1052_Send. Parametry funkce jsou handle zazen (HNDL, typ DWord),
// vyslan data do modulu MicroUnit (BuffT, typ ukazatel na pole DWord),
// data pijat z modulu MicroUnit (BuffR, typ ukazatel na pole DWord),
// pijat Status registr modulu MicroUnit (StatusR, typ ukazatel na DWord)
// a status pijmu jako vsledek komunikace s modulem MicroUnit (StatusP,
// typ ukazatel na DWord).

// Uzaven knihovny. Po ukonen komunikace s moduly je na zvr knihovna
// uzavena funkc TMU1052_Done.

// Vechny funkce ve svm nvratovm kdu vracej informaci o spnosti
// voln vlastn funkce, nikoliv nap. o spnosti komunikace s modulem
// MicroUnit (pro tuto informaci je uren parametr StatusP).

procedure TForm1.FormCreate(Sender: TObject);
var
  HNDL      : DWord;       // handle otevenho zazen MU-1052
  Par       : TPar;        // pole konfiguranch parametr fce Init knihovny
  Baud      : DWord;       // komunikan rychlost modulu MicroUnit, platn
                           // hodnoty : 600, 1200, 2400, 4800, 9600, 19200,
                           // 38400, 57600 a 115200 Bd
  Timeout   : DWord;       // timeout odpovdi modulu, platn hodnoty 1-10000ms
  Opakovani : DWord;       // poet opakovn voln na modul MicroUnit
                           // v ppad chybn komunikace, platn hodnoty 0-15 
  BuffT     : TBuff;       // vyslac buffer, obsahuje data vyslan na modul
                           // MicroUnit (pole DWord)
  BuffR     : TBuff;       // pijmac buffer, obsahuje pijat data z modulu
                           // MicroUnit (pole DWord)
  StatusR   : DWord;       // pijat Status registr modulu MicroUnit
  StatusP   : DWord;       // status pjmu - chybov kd komunikace s modulem MicroUnit
  Chyba     : DWord;       // chybov kd voln funkce
  TextChyby : TBuff;       // slovn vyjden chybovho kdu

  VerzeDLL  : DWord;
  TypMU     : string;
  VerzeMU   : string;
  AIN       : double;
  CNT       : DWord;
  DIN       : DWord;
  DOUT      : DWord;

  I : integer;
begin
  Label7.Caption := '-';
  Label8.Caption := '-';
  Label9.Caption := '-';
  Label10.Caption := '-';
  Label11.Caption := '-';
  Label12.Caption := '-';



// naten verze knihovny ------------------------------------------------------
  Chyba := TMU1052_Version(@VerzeDLL);

  // vyhodnocen chyby voln funkce TMU1052_Version
  if (Chyba <> 0) then
    begin
      TMU1052_Error(Chyba,@TextChyby);
      StatusBar1.Panels[0].Text := 'Chyba TMU1052_Version: '+IntToStr(Chyba)+' - '+PrevodTextError(TextChyby);
      Exit;
    end;

  // vypis verze
  Label7.Caption := FloatToStrF(VerzeDLL/100,ffFixed,5,2);



// inicializace knihovny -------------------------------------------------------
  for I:=0 to 15 do Par[I]:=0;
  Par[0] := DWord(PChar(cAdresaIP));
  Par[1] := cPortUDP;
  Par[2] := cTimeoutUDP;             // parametry inicializace knihovny
  Chyba := TMU1052_Init(@HNDL,@Par);

  // vyhodnocen chyby voln funkce TMU1052_Init
  if (Chyba <> 0) then
    begin
      TMU1052_Error(Chyba,@TextChyby);
      StatusBar1.Panels[0].Text := 'Chyba TMU1052_Init: '+IntToStr(Chyba)+' - '+PrevodTextError(TextChyby);
      Exit;
    end;



// nastaven komunikanch parametr linky RS-485 ------------------------------
  Baud := cBaudMU;                   // volba komunikan rychlosti
  Timeout := cTimeoutMU;             // [ms] timeout odpovdi modulu
  Opakovani := cOpakovaniMU;         // poet opakovn voln pi chyb
  Chyba := TMU1052_SetConfig(HNDL,Baud,Timeout,Opakovani);

  // vyhodnocen chyby voln funkce TMU1052_SetConfig
  if (Chyba <> 0) then
    begin
      TMU1052_Error(Chyba,@TextChyby);
      StatusBar1.Panels[0].Text := 'Chyba TMU1052_SetConfig: '+IntToStr(Chyba)+' - '+PrevodTextError(TextChyby);
      Exit;
    end;



// naten komunikanch parametr linky RS-485 --------------------------------
  Chyba := TMU1052_GetConfig(HNDL,@Baud,@Timeout,@Opakovani);

  // vyhodnocen chyby voln funkce TMU1052_GetConfig
  if (Chyba <> 0) then
    begin
      TMU1052_Error(Chyba,@TextChyby);
      StatusBar1.Panels[0].Text := 'Chyba TMU1052_GetConfig: '+IntToStr(Chyba)+' - '+PrevodTextError(TextChyby);
      Exit;
    end;



// zjitn typu a verze vzdlenho modulu -------------------------------------

  // dotaz AIBus-2 protokolu (prv tyi znaky typovho oznaen modulu)
  BuffT[0] := cAdresaMU;        // adresa modulu MicroUnit
  BuffT[1] := 200;	        // funkce modulu MicroUnit
  BuffT[2] := 0;		// periferie modulu MicroUnit
  BuffT[3] := 0;		// pomocn povel
  BuffT[4] := 0;		// data D0
  BuffT[5] := 0;		// data D1
  BuffT[6] := 0;		// data D2
  BuffT[7] := 0;		// data D3
  Chyba := TMU1052_Send(HNDL, @BuffT, @BuffR, @StatusR, @StatusP);

  // vyhodnocen chyby voln funkce TMU1052_Send
  if (Chyba <> 0) then
    begin
      TMU1052_Error(Chyba,@TextChyby);
      StatusBar1.Panels[0].Text := 'Chyba TMU1052_Send: '+IntToStr(Chyba)+' - '+PrevodTextError(TextChyby);
      Exit;
    end;

  // vyhodnocen chyby komunikace s modulem MicroUnit - StatusP
  if (StatusP <> 0) then
    begin
      TMU1052_Error(StatusP,@TextChyby);
      StatusBar1.Panels[0].Text := 'Status komunikace: '+IntToStr(StatusP)+' - '+PrevodTextError(TextChyby);
      Exit;
    end;

  // pijat data typu ASCII
  TypMU := '';
  TypMU := TypMU + chr(BuffR[0]);
  TypMU := TypMU + chr(BuffR[1]);
  TypMU := TypMU + chr(BuffR[2]);
  TypMU := TypMU + chr(BuffR[3]);



  // dotaz AIBus-2 protokolu (druh tyi znaky typovho oznaen modulu)
  BuffT[0] := cAdresaMU;	// adresa modulu MicroUnit
  BuffT[1] := 200;	        // funkce modulu MicroUnit
  BuffT[2] := 1;		// periferie modulu MicroUnit
  BuffT[3] := 0;		// pomocn povel
  BuffT[4] := 0;		// data D0
  BuffT[5] := 0;		// data D1
  BuffT[6] := 0;		// data D2
  BuffT[7] := 0;		// data D3
  Chyba := TMU1052_Send(HNDL, @BuffT, @BuffR, @StatusR, @StatusP);

  // vyhodnocen chyby voln funkce TMU1052_Send
  if (Chyba <> 0) then
    begin
      TMU1052_Error(Chyba,@TextChyby);
      StatusBar1.Panels[0].Text := 'Chyba TMU1052_Send: '+IntToStr(Chyba)+' - '+PrevodTextError(TextChyby);
      Exit;
    end;

  // vyhodnocen chyby komunikace s modulem MicroUnit - StatusP
  if (StatusP <> 0) then
    begin
      TMU1052_Error(StatusP,@TextChyby);
      StatusBar1.Panels[0].Text := 'Status komunikace: '+IntToStr(StatusP)+' - '+PrevodTextError(TextChyby);
      Exit;
    end;

  // pijat data typu ASCII
  TypMU := TypMU + chr(BuffR[0]);
  TypMU := TypMU + chr(BuffR[1]);
  TypMU := TypMU + chr(BuffR[2]);
  TypMU := TypMU + chr(BuffR[3]);



  // dotaz AIBus-2 protokolu (tyi znaky verze modulu)
  BuffT[0] := cAdresaMU;	// adresa modulu MicroUnit
  BuffT[1] := 200;	        // funkce modulu MicroUnit
  BuffT[2] := 2;		// periferie modulu MicroUnit
  BuffT[3] := 0;		// pomocn povel
  BuffT[4] := 0;		// data D0
  BuffT[5] := 0;		// data D1
  BuffT[6] := 0;		// data D2
  BuffT[7] := 0;		// data D3
  Chyba := TMU1052_Send(HNDL, @BuffT, @BuffR, @StatusR, @StatusP);

  // vyhodnocen chyby voln funkce TMU1052_Send
  if (Chyba <> 0) then
    begin
      TMU1052_Error(Chyba,@TextChyby);
      StatusBar1.Panels[0].Text := 'Chyba TMU1052_Send: '+IntToStr(Chyba)+' - '+PrevodTextError(TextChyby);
      Exit;
    end;

  // vyhodnocen chyby komunikace s modulem MicroUnit - StatusP
  if (StatusP <> 0) then
    begin
      TMU1052_Error(StatusP,@TextChyby);
      StatusBar1.Panels[0].Text := 'Status komunikace: '+IntToStr(StatusP)+' - '+PrevodTextError(TextChyby);
      Exit;
    end;

  // pijat data typu ASCII
  VerzeMU := '';
  VerzeMU := VerzeMU + chr(BuffR[0]);
  VerzeMU := VerzeMU + chr(BuffR[1]);
  VerzeMU := VerzeMU + chr(BuffR[2]);
  VerzeMU := VerzeMU + chr(BuffR[3]);

  // vypis pijatch dat
  Label8.Caption := TypMU + 'v.' + VerzeMU;



// ten analogovho vstupu AIN ------------------------------------------------

  // dotaz AIBus-2 protokolu (AIN0)
  BuffT[0] := cAdresaMU;	// adresa modulu MicroUnit
  BuffT[1] := 0;	        // funkce modulu MicroUnit (0=ten)
  BuffT[2] := 0;		// periferie modulu MicroUnit (0=AIN0)
  BuffT[3] := 0;		// pomocn povel
  BuffT[4] := 0;		// data D0
  BuffT[5] := 0;		// data D1
  BuffT[6] := 0;		// data D2
  BuffT[7] := 0;		// data D3
  Chyba := TMU1052_Send(HNDL, @BuffT, @BuffR, @StatusR, @StatusP);

  // vyhodnocen chyby voln funkce TMU1052_Send
  if (Chyba <> 0) then
    begin
      TMU1052_Error(Chyba,@TextChyby);
      StatusBar1.Panels[0].Text := 'Chyba TMU1052_Send: '+IntToStr(Chyba)+' - '+PrevodTextError(TextChyby);
      Exit;
    end;

  // vyhodnocen chyby komunikace s modulem MicroUnit - StatusP
  if (StatusP <> 0) then
    begin
      TMU1052_Error(StatusP,@TextChyby);
      StatusBar1.Panels[0].Text := 'Status komunikace: '+IntToStr(StatusP)+' - '+PrevodTextError(TextChyby);
      Exit;
    end;

  // pevod pijatch dat na real slo
  AIN := PrevodAIBusDouble(BuffR[0], BuffR[1], BuffR[2], BuffR[3]);

  // vpis pijatch dat
  Label9.Caption := FloatToStrF(AIN,ffFixed,10,6);



// ten tae CNT ------------------------------------------------------------

  // dotaz AIBus-2 protokolu (CNT0)
  BuffT[0] := cAdresaMU;	// adresa modulu MicroUnit
  BuffT[1] := 0;	        // funkce modulu MicroUnit (0=ten)
  BuffT[2] := 80;		// periferie modulu MicroUnit (80=CNT0)
  BuffT[3] := 0;		// pomocn povel
  BuffT[4] := 0;		// data D0
  BuffT[5] := 0;		// data D1
  BuffT[6] := 0;		// data D2
  BuffT[7] := 0;		// data D3
  Chyba := TMU1052_Send(HNDL, @BuffT, @BuffR, @StatusR, @StatusP);

  // vyhodnocen chyby voln funkce TMU1052_Send
  if (Chyba <> 0) then
    begin
      TMU1052_Error(Chyba,@TextChyby);
      StatusBar1.Panels[0].Text := 'Chyba TMU1052_Send: '+IntToStr(Chyba)+' - '+PrevodTextError(TextChyby);
      Exit;
    end;

  // vyhodnocen chyby komunikace s modulem MicroUnit - StatusP
  if (StatusP <> 0) then
    begin
      TMU1052_Error(StatusP,@TextChyby);
      StatusBar1.Panels[0].Text := 'Status komunikace: '+IntToStr(StatusP)+' - '+PrevodTextError(TextChyby);
      Exit;
    end;

  // pevod pijatch dat na real slo
  CNT := PrevodAIBusDWord(BuffR[0], BuffR[1], BuffR[2], BuffR[3]);

  // vpis pijatch dat
  Label10.Caption := IntToStr(CNT);



// ten digitlnch vstup DIN0 a DIN31 --------------------------------------

  // dotaz AIBus-2 protokolu (DIN)
  BuffT[0] := cAdresaMU;	// adresa modulu MicroUnit
  BuffT[1] := 0;	        // funkce modulu MicroUnit (0=ten)
  BuffT[2] := 64;		// periferie modulu MicroUnit (64=DIN)
  BuffT[3] := 0;		// pomocn povel
  BuffT[4] := 0;		// data D0
  BuffT[5] := 0;		// data D1
  BuffT[6] := 0;		// data D2
  BuffT[7] := 0;		// data D3
  Chyba := TMU1052_Send(HNDL, @BuffT, @BuffR, @StatusR, @StatusP);

  // vyhodnocen chyby voln funkce TMU1052_Send
  if (Chyba <> 0) then
    begin
      TMU1052_Error(Chyba,@TextChyby);
      StatusBar1.Panels[0].Text := 'Chyba TMU1052_Send: '+IntToStr(Chyba)+' - '+PrevodTextError(TextChyby);
      Exit;
    end;

  // vyhodnocen chyby komunikace s modulem MicroUnit - StatusP
  if (StatusP <> 0) then
    begin
      TMU1052_Error(StatusP,@TextChyby);
      StatusBar1.Panels[0].Text := 'Status komunikace: '+IntToStr(StatusP)+' - '+PrevodTextError(TextChyby);
      Exit;
    end;

  // pevod pijatch dat
  DIN := PrevodAIBusDWord(BuffR[0], BuffR[1], BuffR[2], BuffR[3]);

  // vpis pijatch dat
  Label11.Caption := IntToHex(DIN,8)+'h';



// zpis digitlnch vstup DOUT0 a DOUT31 -----------------------------------

  // dotaz AIBus-2 protokolu (sepnut DOUT1 a DOUT3, ostatn DOUT vypnout)
  BuffT[0] := cAdresaMU;	// adresa modulu MicroUnit
  BuffT[1] := 1;	        // funkce modulu MicroUnit (1=zapis)
  BuffT[2] := 64;		// periferie modulu MicroUnit (64=DOUT)
  BuffT[3] := 0;		// pomocn povel
  BuffT[4] := $0A;		// data D0
  BuffT[5] := 0;		// data D1
  BuffT[6] := 0;		// data D2
  BuffT[7] := 0;		// data D3
  Chyba := TMU1052_Send(HNDL, @BuffT, @BuffR, @StatusR, @StatusP);

  // vyhodnocen chyby voln funkce TMU1052_Send
  if (Chyba <> 0) then
    begin
      TMU1052_Error(Chyba,@TextChyby);
      StatusBar1.Panels[0].Text := 'Chyba TMU1052_Send: '+IntToStr(Chyba)+' - '+PrevodTextError(TextChyby);
      Exit;
    end;

  // vyhodnocen chyby komunikace s modulem MicroUnit - StatusP
  if (StatusP <> 0) then
    begin
      TMU1052_Error(StatusP,@TextChyby);
      StatusBar1.Panels[0].Text := 'Status komunikace: '+IntToStr(StatusP)+' - '+PrevodTextError(TextChyby);
      Exit;
    end;

  // pevod pijatch dat
  DOUT := PrevodAIBusDWord(BuffR[0], BuffR[1], BuffR[2], BuffR[3]);

  // vpis pijatch dat
  Label12.Caption := IntToHex(DOUT,8)+'h';

  // status komunikace
  TMU1052_Error(StatusP,@TextChyby);
  StatusBar1.Panels[0].Text := 'Status komunikace: '+IntToStr(StatusP)+' - '+PrevodTextError(TextChyby);



// uzavreni knihovny -----------------------------------------------------------
  TMU1052_Done(@HNDL);

end;
//______________________________________________________________________________

end.
