//______________________________________________________________________________

//                   Pklad pouit knihovny Tmu1052.dll

//                           (Visual Studio 2010)

//                Copyright (c) 1998-2014 TEDIA spol. s r.o.
//______________________________________________________________________________


// Program demonstruje voln jednotlivch funkc knihovny Tmu1052 pro
// komunikaci s modulem MicroUnit pes modul MU-1052 resp. MU-1052U.
// Pro pouit knihovny je nutn znalost modulu MicroUnit v rozsahu jeho
// Uivatelsk pruky (implementace periferi u danho modulu).
// Knihovnu nen nutno samostatn instalovat, sta ji v rmci instalace
// aplikanho software pouze pekoprovat do msta, kam bude mt aplikan
// program nastavenu cestu.

//______________________________________________________________________________


#include "stdafx.h"
#include <windows.h>
#include <stdio.h>
#include <stdlib.h>
#include <stdint.h>
#include <locale.h>


//______________________________________________________________ FUNKN PROTOTYPY

// funkce knihovny

typedef uint32_t (__stdcall *t_TMU1052_Version)(uint32_t*);
typedef uint32_t (__stdcall *t_TMU1052_Init)(uint32_t*, uint32_t*);
typedef uint32_t (__stdcall *t_TMU1052_SetConfig)(uint32_t, uint32_t, uint32_t, uint32_t);
typedef uint32_t (__stdcall *t_TMU1052_GetConfig)(uint32_t, uint32_t*, uint32_t*, uint32_t*);
typedef uint32_t (__stdcall *t_TMU1052_Send)(uint32_t, uint32_t*, uint32_t*, uint32_t*, uint32_t*);
typedef uint32_t (__stdcall *t_TMU1052_Done)(uint32_t*);
typedef uint32_t (__stdcall *t_TMU1052_Error)(uint32_t, uint32_t*);

t_TMU1052_Version   TMU1052_Version;
t_TMU1052_Init      TMU1052_Init;
t_TMU1052_SetConfig TMU1052_SetConfig;
t_TMU1052_GetConfig TMU1052_GetConfig;
t_TMU1052_Send      TMU1052_Send;
t_TMU1052_Done      TMU1052_Done;
t_TMU1052_Error     TMU1052_Error;



// pomocn funkce

uint32_t PrevodAIBusDWord(uint32_t D1, uint32_t D2, uint32_t D3, uint32_t D4);
double PrevodAIBusReal(uint32_t D1, uint32_t D2, uint32_t D3, uint32_t D4);
uint8_t* PrevodTextError(uint32_t *B);


//______________________________________________________________ GLOBLN PROMNN

uint32_t Par[16];
uint32_t BuffT[100];
uint32_t BuffR[100];
uint32_t ErrText[100];

HINSTANCE hinstLib;

uint32_t HNDL;

uint32_t AdresaMU    = 1;                // adresa pipojenho modulu MicroUnit k MU-1052
uint32_t BaudMU      = 9600;             // rychlost pipojenho modulu MicroUnit k MU-1052
uint32_t TimeoutMU   = 100;              // [ms] timeout ekn na odpov modulu MicroUnit
uint32_t OpakovaniMU = 2;                // poet opakovanch dotaz pi chyb komunikace

uint8_t  AdresaIP[]  = "192.168.0.99";   // IP adresa modulu MU-1052
uint32_t PortUDP     = 5000;             // UDP port modulu MU-1052
uint32_t TimeoutUDP  = 1000;             // [ms] doba ekn na odpov MU-1052



//______________________________________________________________ main

int _tmain(int argc, _TCHAR* argv[])
{
  uint32_t i;
  uint32_t result;
  BOOL fFreeResult;



// nastaven znakov sady
  char* localcharset = setlocale(LC_ALL, "");
  if (localcharset == NULL)
  {
    printf("Locale not set\n");
  }



// nataen knihovny do pamti

  hinstLib = LoadLibrary(TEXT("Tmu1052.dll"));
  if (hinstLib == NULL)
  {
    printf("Chyba volani funkce LoadLibrary\n");
    fFreeResult = FreeLibrary(hinstLib);
    return 1;
  }



// zjitn adres funkc v knihovn

  TMU1052_Version = (t_TMU1052_Version) GetProcAddress(hinstLib, "TMU1052_Version");
  TMU1052_Init = (t_TMU1052_Init) GetProcAddress(hinstLib, "TMU1052_Init");
  TMU1052_SetConfig = (t_TMU1052_SetConfig) GetProcAddress(hinstLib, "TMU1052_SetConfig");
  TMU1052_GetConfig = (t_TMU1052_GetConfig) GetProcAddress(hinstLib, "TMU1052_GetConfig");
  TMU1052_Send = (t_TMU1052_Send) GetProcAddress(hinstLib, "TMU1052_Send");
  TMU1052_Done = (t_TMU1052_Done) GetProcAddress(hinstLib, "TMU1052_Done");
  TMU1052_Error = (t_TMU1052_Error) GetProcAddress(hinstLib, "TMU1052_Error");



// naten verze knihovny ------------------------------------------------------

  uint32_t VerzeDLL;

  result = TMU1052_Version(&VerzeDLL);

  // vyhodnocen chyby voln funkce TMU1052_Version
  if (result!=0)
  {
    TMU1052_Error(result, ErrText);
    printf("Result TMU1052_Version: %lu - %s\n", (unsigned long)result, PrevodTextError(ErrText));
    return 0;
  }

  // vpis verze
  printf("Verze knihovny Tmu1052.dll: %d.%02d\n",  (VerzeDLL/100), (VerzeDLL%100));



// inicializace knihovny -------------------------------------------------------

  for (i=0;i<16;i++) Par[i] = 0;
  Par[0] = (uint32_t)AdresaIP;		    // IP adresa modulu MU-1052U
  Par[1] = PortUDP;			              // UDP port modulu MU-1052U
  Par[2] = TimeoutUDP;			          // [ms] LAN timeout
  result = TMU1052_Init(&HNDL, Par);

  // vyhodnocen chyby voln funkce TMU1052_Init
  if (result!=0)
  {
    TMU1052_Error(result, ErrText);
    printf("Result TMU1052_Init: %lu - %s\n", (unsigned long)result, PrevodTextError(ErrText));
    return 0;
  }



// nastaven komunikanch parametr linky RS-485 ------------------------------

  result = TMU1052_SetConfig(HNDL, BaudMU, TimeoutMU, OpakovaniMU);

  // vyhodnocen chyby voln funkce TMU1052_SetConfig
  if (result!=0)
  {

    TMU1052_Error(result, ErrText);
    printf("Result TMU1052_SetConfig: %lu - %s\n", (unsigned long)result, PrevodTextError(ErrText));
    return 0;
  }



// naten komunikanch parametr linky RS-485 --------------------------------

  result = TMU1052_GetConfig(HNDL, &BaudMU, &TimeoutMU, &OpakovaniMU);

  // vyhodnocen chyby voln funkce TMU1052_GetConfig
  if (result!=0)
  {
    TMU1052_Error(result, ErrText);
    printf("Result TMU1052_GetConfig: %lu - %s\n", (unsigned long)result, PrevodTextError(ErrText));
    return 0;
  }

  // vpis komunikanch parametr
  printf("Baud: %lu  Timeout: %lu  Opakovani: %lu\n", (unsigned long) BaudMU, (unsigned long) TimeoutMU, (unsigned long) OpakovaniMU);



// zjitn typu a verze vzdlenho modulu -------------------------------------

  uint32_t StatusR;
  uint32_t StatusP;

  uint8_t TypMU[9];
  uint8_t VerzeMU[5];

  // dotaz AIBus-2 protokolu (prv tyi znaky typovho oznaen modulu)
  BuffT[0] = AdresaMU;	      // adresa modulu MicroUnit
  BuffT[1] = 200;	      // funkce modulu MicroUnit
  BuffT[2] = 0;		      // periferie modulu MicroUnit
  BuffT[3] = 0;		      // pomocn povel
  BuffT[4] = 0;		      // data D0
  BuffT[5] = 0;		      // data D1
  BuffT[6] = 0;		      // data D2
  BuffT[7] = 0;		      // data D3
  result = TMU1052_Send(HNDL, BuffT, BuffR, &StatusR, &StatusP);

  // vyhodnocen chyby voln funkce TMU1052_Send
  if (result!=0)
  {
    TMU1052_Error(result, ErrText);
    printf("Result TMU1052_Send: %lu - %s\n", (unsigned long) result, PrevodTextError(ErrText));
    return 0;
  }

  // vyhodnocen chyby komunikace s modulem MicroUnit - StatusP
  if (StatusP!=0)
  {
    TMU1052_Error(StatusP, ErrText);
    printf("Status komunikace: %lu - %s\n", (unsigned long) StatusP, PrevodTextError(ErrText));
    return 0;
  }

  // pevod pijatch dat
  TypMU[0] = (uint8_t)BuffR[0];
  TypMU[1] = (uint8_t)BuffR[1];
  TypMU[2] = (uint8_t)BuffR[2];
  TypMU[3] = (uint8_t)BuffR[3];



  // dotaz AIBus-2 protokolu (druh tyi znaky typovho oznaen modulu)
  BuffT[0] = AdresaMU;	      // adresa modulu MicroUnit
  BuffT[1] = 200;	      // funkce modulu MicroUnit
  BuffT[2] = 1;		      // periferie modulu MicroUnit
  BuffT[3] = 0;		      // pomocn povel
  BuffT[4] = 0;		      // data D0
  BuffT[5] = 0;		      // data D1
  BuffT[6] = 0;		      // data D2
  BuffT[7] = 0;		      // data D3
  result = TMU1052_Send(HNDL, BuffT, BuffR, &StatusR, &StatusP);

  // vyhodnocen chyby voln funkce TMU1052_Send
  if (result!=0)
  {
    TMU1052_Error(result, ErrText);
    printf("Result TMU1052_Send: %lu - %s\n", (unsigned long) result, PrevodTextError(ErrText));
    return 0;
  }

  // vyhodnocen chyby komunikace s modulem MicroUnit - StatusP
  if (StatusP!=0)
  {
    TMU1052_Error(StatusP, ErrText);
    printf("Status komunikace: %lu - %s\n", (unsigned long) StatusP, PrevodTextError(ErrText));
    return 0;
  }

  // pevod pijatch dat
  TypMU[4] = (uint8_t)BuffR[0];
  TypMU[5] = (uint8_t)BuffR[1];
  TypMU[6] = (uint8_t)BuffR[2];
  TypMU[7] = (uint8_t)BuffR[3];
  TypMU[8] = 0;



  // dotaz AIBus-2 protokolu (tyi znaky verze modulu)
  BuffT[0] = AdresaMU;	      // adresa modulu MicroUnit
  BuffT[1] = 200;	      // funkce modulu MicroUnit
  BuffT[2] = 2;		      // periferie modulu MicroUnit
  BuffT[3] = 0;		      // pomocn povel
  BuffT[4] = 0;		      // data D0
  BuffT[5] = 0;		      // data D1
  BuffT[6] = 0;		      // data D2
  BuffT[7] = 0;		      // data D3
  result = TMU1052_Send(HNDL, BuffT, BuffR, &StatusR, &StatusP);

  // vyhodnocen chyby voln funkce TMU1052_Send
  if (result!=0)
  {
    TMU1052_Error(result, ErrText);
    printf("Result TMU1052_Send: %lu - %s\n", (unsigned long) result, PrevodTextError(ErrText));
    return 0;
  }

  // vyhodnocen chyby komunikace s modulem MicroUnit - StatusP
  if (StatusP!=0)
  {
    TMU1052_Error(StatusP, ErrText);
    printf("Status komunikace: %lu - %s\n", (unsigned long) StatusP, PrevodTextError(ErrText));
    return 0;
  }

  // pevod pijatch dat
  VerzeMU[0] = (uint8_t)BuffR[0];
  VerzeMU[1] = (uint8_t)BuffR[1];
  VerzeMU[2] = (uint8_t)BuffR[2];
  VerzeMU[3] = (uint8_t)BuffR[3];
  VerzeMU[4] = 0;

  // vpis pijatch dat
  printf("StatusP: %lu  StatusR: %lu  Typ modulu: %s  Verze modulu: %s\n", (unsigned long) StatusP, (unsigned long) StatusR, TypMU, VerzeMU);



// ten analogovho vstupu AIN ------------------------------------------------

  double AIN;

  // dotaz AIBus-2 protokolu (AIN0)
  BuffT[0] = AdresaMU;	      // adresa modulu MicroUnit
  BuffT[1] = 0;		      // funkce modulu MicroUnit (0=ten)
  BuffT[2] = 0;		      // periferie modulu MicroUnit (0=AIN0)
  BuffT[3] = 0;		      // pomocn povel
  BuffT[4] = 0;		      // data D0
  BuffT[5] = 0;		      // data D1
  BuffT[6] = 0;		      // data D2
  BuffT[7] = 0;		      // data D3
  result = TMU1052_Send(HNDL, BuffT, BuffR, &StatusR, &StatusP);

  // vyhodnocen chyby voln funkce TMU1052_Send
  if (result!=0)
  {
    TMU1052_Error(result, ErrText);
    printf("Result TMU1052_Send: %lu - %s\n", (unsigned long) result, PrevodTextError(ErrText));
    return 0;
  }

  // vyhodnocen chyby komunikace s modulem MicroUnit - StatusP
  if (StatusP!=0)
  {
    TMU1052_Error(StatusP, ErrText);
    printf("Status komunikace: %lu - %s\n", (unsigned long) StatusP, PrevodTextError(ErrText));
    return 0;
  }

  // pevod pijatch dat
  AIN = PrevodAIBusReal(BuffR[0], BuffR[1], BuffR[2], BuffR[3]);

  // vpis pijatch dat
  printf("StatusP: %lu  StatusR: %lu  Analogovy vstup AIN0: %4.1f \n", (unsigned long) StatusP, (unsigned long) StatusR, AIN);



// ten tae CNT ------------------------------------------------------------

  uint32_t CNT;

  // dotaz AIBus-2 protokolu (AIN16)
  BuffT[0] = AdresaMU;	      // adresa modulu MicroUnit
  BuffT[1] = 0;		      // funkce modulu MicroUnit (0=ten)
  BuffT[2] = 80;	      // periferie modulu MicroUnit (80=CNT0)
  BuffT[3] = 0;		      // pomocn povel
  BuffT[4] = 0;		      // data D0
  BuffT[5] = 0;		      // data D1
  BuffT[6] = 0;		      // data D2
  BuffT[7] = 0;		      // data D3
  result = TMU1052_Send(HNDL, BuffT, BuffR, &StatusR, &StatusP);

  // vyhodnocen chyby voln funkce TMU1052_Send
  if (result!=0)
  {
    TMU1052_Error(result, ErrText);
    printf("Result TMU1052_Send: %lu - %s\n", (unsigned long) result, PrevodTextError(ErrText));
    return 0;
  }

  // vyhodnocen chyby komunikace s modulem MicroUnit - StatusP
  if (StatusP!=0)
  {
    TMU1052_Error(StatusP, ErrText);
    printf("Status komunikace: %lu - %s\n", (unsigned long) StatusP, PrevodTextError(ErrText));
    return 0;
  }

  // pevod pijatch dat
  CNT = PrevodAIBusDWord(BuffR[0], BuffR[1], BuffR[2], BuffR[3]);

  // vpis pijatch dat
  printf("StatusP: %lu  StatusR: %lu  Citac CNT0: %lu\n", (unsigned long) StatusP, (unsigned long) StatusR, (unsigned long) CNT);



  // ten digitlnch vstup DIN0 a DIN31 --------------------------------------

  // dotaz AIBus-2 protokolu (DIN)
  BuffT[0] = AdresaMU;	      // adresa modulu MicroUnit
  BuffT[1] = 0;		      // funkce modulu MicroUnit (0=ten)
  BuffT[2] = 64;	      // periferie modulu MicroUnit (64=DIN)
  BuffT[3] = 0;		      // pomocn povel
  BuffT[4] = 0;		      // data D0
  BuffT[5] = 0;		      // data D1
  BuffT[6] = 0;		      // data D2
  BuffT[7] = 0;		      // data D3
  result = TMU1052_Send(HNDL, BuffT, BuffR, &StatusR, &StatusP);

  // vyhodnocen chyby voln funkce TMU1052_Send
  if (result!=0)
  {
    TMU1052_Error(result, ErrText);
    printf("Result TMU1052_Send: %lu - %s\n", (unsigned long) result, PrevodTextError(ErrText));
    return 0;
  }

  // vyhodnocen chyby komunikace s modulem MicroUnit - StatusP
  if (StatusP!=0)
  {
    TMU1052_Error(StatusP, ErrText);
    printf("Status komunikace: %lu - %s\n", (unsigned long) StatusP, PrevodTextError(ErrText));
    return 0;
  }

  // vpis pijatch dat
  printf("StatusP: %lu  StatusR: %lu  Digitalni vstupy DIN0-DIN31: %02x %02x %02x %02x\n",
         (unsigned long) StatusP,
         (unsigned long) StatusR,
         (unsigned char)BuffR[0],
         (unsigned char)BuffR[1],
         (unsigned char)BuffR[2],
         (unsigned char)BuffR[3]);



  // zpis digitlnch vstup DOUT0 a DOUT31 -----------------------------------

  // dotaz AIBus-2 protokolu (sepnut DOUT1 a DOUT3, ostatn DOUT vypnout)
  BuffT[0] = AdresaMU;	      // adresa modulu MicroUnit
  BuffT[1] = 1;		      // funkce modulu MicroUnit (1=zpis)
  BuffT[2] = 64;	      // periferie modulu MicroUnit (64=DOUT)
  BuffT[3] = 0;		      // pomocn povel
  BuffT[4] = 0x0A;	      // data D0 (DOUT0-7)
  BuffT[5] = 0;		      // data D1 (DOUT8-15)
  BuffT[6] = 0;		      // data D2 (DOUT16-23)
  BuffT[7] = 0;		      // data D3 (DOUT24-31)
  result = TMU1052_Send(HNDL, BuffT, BuffR, &StatusR, &StatusP);

  // vyhodnocen chyby voln funkce TMU1052_Send
  if (result!=0)
  {
    TMU1052_Error(result, ErrText);
    printf("Result TMU1052_Send: %lu - %s\n", (unsigned long) result, PrevodTextError(ErrText));
    return 0;
  }

  // vyhodnocen chyby komunikace s modulem MicroUnit - StatusP
  if (StatusP!=0)
  {
    TMU1052_Error(StatusP, ErrText);
    printf("Status komunikace: %lu - %s\n", (unsigned long) StatusP, PrevodTextError(ErrText));
    return 0;
  }

  // vpis pijatch dat
  printf("StatusP: %lu  StatusR: %lu  Digitalni vystupy DOUT0-DOUT31: %02x %02x %02x %02x\n",
         (unsigned long) StatusP,
         (unsigned long) StatusR,
         (unsigned char)BuffR[0],
         (unsigned char)BuffR[1],
         (unsigned char)BuffR[2],
         (unsigned char)BuffR[3]);



  // uzaven knihovny (TMU1052_Done) --------------------------------------------

  result = TMU1052_Done(&HNDL);

  // vyhodnocen chyby voln funkce TMU1052_Done
  if (result!=0)
  {
    TMU1052_Error(result, ErrText);
    printf("Result TMU1052_Done: %lu - %s\n", (unsigned long) result, PrevodTextError(ErrText));
    return 0;
  }



  // uvolnn knihovny z pamti --------------------------------------------------

  fFreeResult = FreeLibrary(hinstLib);
  printf("Result Free: %u\n", (unsigned int)fFreeResult);



  return 0;
}

//______________________________________________________________ PrevodAIBusDWord

// Funkce pro pevod pijat zprvy na selnou hodnotu. Vstupem je pijat
// datov st odpovdi modulu MicroUnit, vstupem je spotan DWord hodnota.

uint32_t PrevodAIBusDWord(uint32_t D1, uint32_t D2, uint32_t D3, uint32_t D4)
{
  uint32_t R;

  R = D4;
  R = R*256 + D3;
  R = R*256 + D2;
  R = R*256 + D1;

  return R;
}

//______________________________________________________________ PrevodAIBusDouble

// Funkce pro pevod pijat zprvy na hodnotu real. Vstupem je pijat
// datov st odpovdi modulu MicroUnit, vstupem je spotan real hodnota.

double PrevodAIBusReal(uint32_t D1, uint32_t D2, uint32_t D3, uint32_t D4)
{
  uint8_t i,Exp;
  double R;

  R=(D3&0x7F)*1.0;
  R=(R*256.0+D2)*256.0+D1;
  if(D3>127) R=-R;
  Exp=D4&0x7F;
  if(Exp>0)
  {
    for(i=0;i<Exp;i++)
    {
      R=R/10.0;
    }
  }
  return R;
}


//________________________________________________________ PrevodTextError

// Funkce pro pevod pole typu Buff na string. Vstupem je text ve form pole,
// vstupem je text ve form stringu.

uint8_t* PrevodTextError(uint32_t *B)
{
  static uint8_t s[128];
  uint32_t i;

  for(i=0; (B[i]!=0) && (i<100); i++)
  {
    s[i] = (uint8_t)B[i];
  }

  return s;
}

//______________________________________________________________________________
