
//______________________________________________________________________________
//______________________________________________________________________________
//______________________________________________________________________________
{
                                    1.10.2020
                               TEDIA_TUDFT2 v.1.0.1
                           (c) 2020 TEDIA spol. s r. o.
                           http://www.tedia.cz/podpora
}
//______________________________________________________________________________
//______________________________________________________________________________
//______________________________________________________________________________


unit tedia_tudft2;

interface

uses
  Windows, Classes;

//______________________________________________________________________________

const
  // return code TUDFT2_RET
  TUDFT2_RET_OK                     = 0;
  TUDFT2_RET_InvalidHandle          = 1;
  TUDFT2_RET_ParameterError         = 2;
  TUDFT2_RET_DeviceNotFound         = 101;
  TUDFT2_RET_DeviceOpenFailure      = 102;
  TUDFT2_RET_FTD2xxError            = 103;
  TUDFT2_RET_CannotBePerformedYet   = 201;

  // parameter deviceStatus
  TUDFT2_DeviceStatus_OK                   = $00000000;
  TUDFT2_DeviceStatus_FPGAFirmwareStopped  = $00000001;
  TUDFT2_DeviceStatus_FPGANotProgrammed    = $00000002;
  TUDFT2_DeviceStatus_ChecksumInvalid      = $00000004;
  TUDFT2_DeviceStatus_SupplyVoltageNotOK   = $00000008;

  // parameter responseStatus
  TUDFT2_ResponseStatus_OK         = $00000000;
  TUDFT2_ResponseStatus_Busy       = $00000001;
  TUDFT2_ResponseStatus_Timeout    = $00000002;
  TUDFT2_ResponseStatus_Error      = $00000004;

  // parameter globalStatus
  TUDFT2_GlobalStatus_OK                 = $00000000;
  TUDFT2_GlobalStatus_PacketError        = $00000001;
  TUDFT2_GlobalStatus_BufferOverflow     = $00000002;
  TUDFT2_GlobalStatus_MeasurementError   = $01000000;
  TUDFT2_GlobalStatus_GenerationError    = $02000000;
  TUDFT2_GlobalStatus_DeviceError        = $04000000;

  // parameter typeCB
  TUDFT2_TypeCB_Send = 0;

//______________________________________________________________________________

type
  TUDFT2_RET    = DWord;
  TUDFT2_HANDLE = pointer;

  // buffers
  TUDFT2_CommandBuffer   = array[0..199] of DWord;
  PTUDFT2_CommandBuffer  = ^TUDFT2_CommandBuffer;
  TUDFT2_ResponseBuffer  = array[0..199] of DWord;
  PTUDFT2_ResponseBuffer = ^TUDFT2_ResponseBuffer;

  // callback function (called after completing the TUDFT2_SendCommand)
  TUDFT2_Callback = procedure(hndl:DWord; typeCB:DWORD; commandID:DWORD); stdcall;

//______________________________________________________________________________

function TUDFT2_Init : TUDFT2_HANDLE; stdcall;
function TUDFT2_Done(handle:TUDFT2_HANDLE) : TUDFT2_RET; stdcall;
function TUDFT2_InterfaceVersion : DWORD; stdcall;
function TUDFT2_DriverVersion(handle:TUDFT2_HANDLE; version:PDWORD) : TUDFT2_RET; stdcall;

function TUDFT2_DevicesInSystem(handle:TUDFT2_HANDLE; count:PDWORD) : TUDFT2_RET; stdcall;
function TUDFT2_Device_VID(handle:TUDFT2_HANDLE; inx:DWORD; vid:PDWORD) : TUDFT2_RET; stdcall;
function TUDFT2_Device_PID(handle:TUDFT2_HANDLE; inx:DWORD; pid:PDWORD) : TUDFT2_RET; stdcall;
function TUDFT2_Device_SerNo(handle:TUDFT2_HANDLE; inx:DWORD; serNo:PDWORD) : TUDFT2_RET; stdcall;
function TUDFT2_Device_TypeNo(handle:TUDFT2_HANDLE; inx:DWORD; typeNo:PDWORD) : TUDFT2_RET; stdcall;

function TUDFT2_Open(handle:TUDFT2_HANDLE; inx:DWORD; driverCallback:POINTER) : TUDFT2_RET; stdcall;
function TUDFT2_Close(handle:TUDFT2_HANDLE) : TUDFT2_RET; stdcall;
function TUDFT2_GetDeviceStatus(handle:TUDFT2_HANDLE; deviceStatus:PDWORD) : TUDFT2_RET; stdcall;
function TUDFT2_DeviceReset(handle:TUDFT2_HANDLE) : TUDFT2_RET; stdcall;

function TUDFT2_SendCommand(handle:TUDFT2_HANDLE; commandID:DWORD; command:PTUDFT2_CommandBuffer; commandLen:DWORD) : TUDFT2_RET; stdcall;
function TUDFT2_ReadCommandResponse(handle:TUDFT2_HANDLE; timeout:DWORD; commandID:PDWORD; response:PTUDFT2_ResponseBuffer; responseLen:PDWORD; responseStatus:PDWORD) : TUDFT2_RET; stdcall;

function TUDFT2_GetDataBuffersStatus(handle:TUDFT2_HANDLE; outBufferSize:PDWORD; outBufferUsedSpace:PDWORD; outBufferFreeSpace:PDWORD; inBufferSize:PDWORD; inBufferUsedSpace:PDWORD; inBufferFreeSpace:PDWORD; globalStatus:PDWORD) : TUDFT2_RET; stdcall;
function TUDFT2_GetDeviceBuffersStatus(handle:TUDFT2_HANDLE; outBufferSize:PDWORD; outBufferUsedSpace:PDWORD; outBufferFreeSpace:PDWORD; inBufferSize:PDWORD; inBufferUsedSpace:PDWORD; inBufferFreeSpace:PDWORD; globalStatus:PDWORD) : TUDFT2_RET; stdcall;
function TUDFT2_ReadDataBuffer(handle:TUDFT2_HANDLE; dataBuffer:POINTER; dataRequested:DWORD; dataConfirmed:PDWORD) : TUDFT2_RET; stdcall;
function TUDFT2_WriteDataBuffer(handle:TUDFT2_HANDLE; dataBuffer:POINTER; dataRequested:DWORD; dataConfirmed:PDWORD) : TUDFT2_RET; stdcall;
function TUDFT2_StartStopDataBufferTransfer(handle:TUDFT2_HANDLE; runOut:DWORD; runIn:DWORD) : TUDFT2_RET; stdcall;
function TUDFT2_ClearDataBuffers(handle:TUDFT2_HANDLE; clearOut:DWORD; clearIn:DWORD) : TUDFT2_RET; stdcall;

//______________________________________________________________________________

implementation

function  TUDFT2_Init;                              external 'tedia_tudft2.dll';
function  TUDFT2_Done;                              external 'tedia_tudft2.dll';
function  TUDFT2_InterfaceVersion;                  external 'tedia_tudft2.dll';
function  TUDFT2_DriverVersion;                     external 'tedia_tudft2.dll';

function  TUDFT2_DevicesInSystem;                   external 'tedia_tudft2.dll';
function  TUDFT2_Device_VID;                        external 'tedia_tudft2.dll';
function  TUDFT2_Device_PID;                        external 'tedia_tudft2.dll';
function  TUDFT2_Device_SerNo;                      external 'tedia_tudft2.dll';
function  TUDFT2_Device_TypeNo;                     external 'tedia_tudft2.dll';

function  TUDFT2_Open;                              external 'tedia_tudft2.dll';
function  TUDFT2_Close;                             external 'tedia_tudft2.dll';
function  TUDFT2_GetDeviceStatus;                   external 'tedia_tudft2.dll';
function  TUDFT2_DeviceReset;                       external 'tedia_tudft2.dll';

function  TUDFT2_SendCommand;                       external 'tedia_tudft2.dll';
function  TUDFT2_ReadCommandResponse;               external 'tedia_tudft2.dll';

function  TUDFT2_GetDataBuffersStatus;              external 'tedia_tudft2.dll';
function  TUDFT2_GetDeviceBuffersStatus;            external 'tedia_tudft2.dll';
function  TUDFT2_ReadDataBuffer;                    external 'tedia_tudft2.dll';
function  TUDFT2_WriteDataBuffer;                   external 'tedia_tudft2.dll';
function  TUDFT2_StartStopDataBufferTransfer;       external 'tedia_tudft2.dll';
function  TUDFT2_ClearDataBuffers;                  external 'tedia_tudft2.dll';

//______________________________________________________________________________

begin
end.


