
//______________________________________________________________________________
//______________________________________________________________________________
//______________________________________________________________________________
/*            
                                    1.10.2020
                               TEDIA_TUDFT2 v.1.0.1
                           (c) 2020 TEDIA spol. s r. o.
                           http://www.tedia.cz/podpora
*/
//______________________________________________________________________________
//______________________________________________________________________________
//______________________________________________________________________________


#ifndef __TEDIA_TUDFT2_H
#define __TEDIA_TUDFT2_H


#ifdef      BUILD_TEDIA_TUDFT2_DLL
    #define     TUDFT2_API      __declspec(dllexport) __stdcall
#else
    #define     TUDFT2_API      __declspec(dllimport) __stdcall
#endif


#include <windows.h>


#ifdef  __cplusplus
extern "C" {
#endif


//______________________________________________________________________________

// return code TUDFT2_RET
#define  TUDFT2_RET_OK                      0
#define  TUDFT2_RET_InvalidHandle           1
#define  TUDFT2_RET_ParameterError          2
#define  TUDFT2_RET_DeviceNotFound          101
#define  TUDFT2_RET_DeviceOpenFailure       102
#define  TUDFT2_RET_FTD2xxError             103
#define  TUDFT2_RET_CannotBePerformedYet    201

// parameter deviceStatus
#define  TUDFT2_DeviceStatus_OK                     0x00000000
#define  TUDFT2_DeviceStatus_FPGAFirmwareStopped    0x00000001
#define  TUDFT2_DeviceStatus_FPGANotProgrammed      0x00000002
#define  TUDFT2_DeviceStatus_ChecksumInvalid        0x00000004
#define  TUDFT2_DeviceStatus_SupplyVoltageNotOK     0x00000008

// parameter responseStatus
#define  TUDFT2_ResponseStatus_OK         0x00000000
#define  TUDFT2_ResponseStatus_Busy       0x00000001
#define  TUDFT2_ResponseStatus_Timeout    0x00000002
#define  TUDFT2_ResponseStatus_Error      0x00000004

// parameter globalStatus
#define  TUDFT2_GlobalStatus_OK                 0x00000000
#define  TUDFT2_GlobalStatus_PacketError        0x00000001
#define  TUDFT2_GlobalStatus_BufferOverflow     0x00000002
#define  TUDFT2_GlobalStatus_MeasurementError   0x01000000
#define  TUDFT2_GlobalStatus_GenerationError    0x02000000
#define  TUDFT2_GlobalStatus_DeviceError        0x04000000

// parameter typeCB
#define  TUDFT2_TypeCB_Send       0


//______________________________________________________________________________

typedef   DWORD     TUDFT2_RET;
typedef   VOID*     TUDFT2_HANDLE;

// buffers
typedef   DWORD     TUDFT2_CommandBuffer[200];
typedef   DWORD     TUDFT2_ResponseBuffer[200];

// callback function (called after completing the TUDFT2_SendCommand)
typedef void (__stdcall *TUDFT2_Callback)(TUDFT2_HANDLE handle, DWORD typeCB, DWORD commandID);

//______________________________________________________________________________

TUDFT2_HANDLE  TUDFT2_API  TUDFT2_Init(VOID);
TUDFT2_RET     TUDFT2_API  TUDFT2_Done(TUDFT2_HANDLE handle);
DWORD          TUDFT2_API  TUDFT2_InterfaceVersion(VOID);
TUDFT2_RET     TUDFT2_API  TUDFT2_DriverVersion(TUDFT2_HANDLE handle, DWORD * version);

TUDFT2_RET     TUDFT2_API  TUDFT2_DevicesInSystem(TUDFT2_HANDLE handle, DWORD * count);
TUDFT2_RET     TUDFT2_API  TUDFT2_Device_VID(TUDFT2_HANDLE handle, DWORD inx, DWORD * vid);
TUDFT2_RET     TUDFT2_API  TUDFT2_Device_PID(TUDFT2_HANDLE handle, DWORD inx, DWORD * pid);
TUDFT2_RET     TUDFT2_API  TUDFT2_Device_SerNo(TUDFT2_HANDLE handle, DWORD inx, DWORD * serNo);
TUDFT2_RET     TUDFT2_API  TUDFT2_Device_TypeNo(TUDFT2_HANDLE handle, DWORD inx, DWORD * typeNo);

TUDFT2_RET     TUDFT2_API  TUDFT2_Open(TUDFT2_HANDLE handle, DWORD inx, VOID * driverCallback);
TUDFT2_RET     TUDFT2_API  TUDFT2_Close(TUDFT2_HANDLE handle);
TUDFT2_RET     TUDFT2_API  TUDFT2_GetDeviceStatus(TUDFT2_HANDLE handle, DWORD * deviceStatus);
TUDFT2_RET     TUDFT2_API  TUDFT2_DeviceReset(TUDFT2_HANDLE handle);

TUDFT2_RET     TUDFT2_API  TUDFT2_SendCommand(TUDFT2_HANDLE handle, DWORD commandID, TUDFT2_CommandBuffer * command, DWORD commandLen);
TUDFT2_RET     TUDFT2_API  TUDFT2_ReadCommandResponse(TUDFT2_HANDLE handle, DWORD timeout, DWORD * commandID, TUDFT2_ResponseBuffer * response, DWORD * responseLen, DWORD * responseStatus);

TUDFT2_RET     TUDFT2_API  TUDFT2_GetDataBuffersStatus(TUDFT2_HANDLE handle, DWORD * outBufferSize, DWORD * outBufferUsedSpace, DWORD * outBufferFreeSpace, DWORD * inBufferSize, DWORD * inBufferUsedSpace, DWORD * inBufferFreeSpace, DWORD * globalStatus);
TUDFT2_RET     TUDFT2_API  TUDFT2_GetDeviceBuffersStatus(TUDFT2_HANDLE handle, DWORD * outBufferSize, DWORD * outBufferUsedSpace, DWORD * outBufferFreeSpace, DWORD * inBufferSize, DWORD * inBufferUsedSpace, DWORD * inBufferFreeSpace, DWORD * globalStatus);
TUDFT2_RET     TUDFT2_API  TUDFT2_ReadDataBuffer(TUDFT2_HANDLE handle, BYTE * dataBuffer, DWORD dataRequested, DWORD * dataConfirmed);
TUDFT2_RET     TUDFT2_API  TUDFT2_WriteDataBuffer(TUDFT2_HANDLE handle, BYTE * dataBuffer, DWORD dataRequested, DWORD * dataConfirmed);
TUDFT2_RET     TUDFT2_API  TUDFT2_StartStopDataBufferTransfer(TUDFT2_HANDLE handle, DWORD runOut, DWORD runIn);
TUDFT2_RET     TUDFT2_API  TUDFT2_ClearDataBuffers(TUDFT2_HANDLE handle, DWORD clearOut, DWORD clearIn);

//______________________________________________________________________________

#ifdef __cplusplus
 }
#endif

#endif

