//______________________________________________________________________________
//
//            Hlavikov soubor knihovny TEDIA_OX952.DLL pro Delphi
//
//                                verze 3.06
//
//                        (c) TEDIA 2012 (8.8.2012)
// 
//                            daq_support@tedia.cz
//
//______________________________________________________________________________
//______________________________________________________________________________
//______________________________________________________________________________

unit tedia_ox952;

interface
uses Windows;


//______________________________________________________________________________

const

//........................................... nvratov kdy funkc (OX952_RET)

  OX952_Ok		  = $00000000;
// OX952_NotRunning       = $00000001; removed in >3.0 
  OX952_BadIndex	  = $00000002;
  OX952_AlreadyOpened     = $00000004;
  OX952_CardOpenErr       = $00000008;
// OX952_CardRegisterErr  = $00000010; removed in >3.0 
  OX952_IntEnableErr      = $00000020;
  OX952_NotOpened         = $00000040;
  OX952_BAR05Err          = $00000080;    // UART
  OX952_IntDisabled       = $00000100;
  OX952_StopIntThread     = $00000200;
  OX952_NullPointer       = $00000400;
  OX952_CreateEvent       = $00000800;
  OX952_WaitTimeout       = $00001000;
  OX952_BAR11Err          = $00004000;    // paralelni sbernice
  OX952_BAR13Err          = $00008000;    // konfig. registry
  OX952_IntPending        = $00010000;
  OX952_NoCoupledDevice   = $00020000;    // nesparovane zarizeni
  OX952_OpenedSameProcess = $00040000;
  OX952_VersionConflict	  = $80000000;



//............................................................. DID karet TEDIA

  DID_PCT7303B_F0 = $0200;         // PCT-7303B
  DID_PCT7303B_F1 = $0201;         // PCT-7303B
  DID_PCT7303B_DN4000_F0 = $02F0;  // PCT-7303B DN4000
  DID_PCT7303B_DN4000_F1 = $02F1;  // PCT-7303B DN4000
  DID_PCD7004B_F0 = $0300;         // PCD-7004B
  DID_PCD7004B_F1 = $0301;         // PCD-7004B
  DID_PCI1054U    = $0401;         // PCI-1054U
  DID_PCI1054U_DN4000_F1 = $04F1;  // PCI-1054U DN4000




type
  OX952_RET  = Cardinal;
  DWord      = Cardinal;
  PWord      = ^Word;
  PDWord     = ^DWord;



//_____________________________________________________________ EXPORTOVAN FCE


function OX952_DriverVersion(ver:PDWORD):OX952_RET;                       stdcall;
// Vrac verzi driveru.

function OX952_InterfaceVersion:DWord;                                    stdcall;
// Vrac verzi knihovny Tedia_OX952.

function OX952_CardsInSystem(count:PDWORD):OX952_RET;                     stdcall;
// Vrac poet karet s adiem OX952.

function OX952_Card_DID(inx:DWord; did:PDWord):OX952_RET;                 stdcall;
// Vrac DID karty Index (0 a PocetKaret-1).

function OX952_Card_BUS(inx:DWord; bus:PDWord):OX952_RET;                 stdcall;
// Vrac BUS karty Index (0 a PocetKaret-1).

function OX952_Card_SLOT(inx:DWord; slot:PDWord):OX952_RET;               stdcall;
// Vrac SLOT karty Index (0 a PocetKaret-1).

function OX952_Open(inx:DWord; enable_irq:DWord):OX952_RET;               stdcall;
// Oteve danou (inx) kartu a
// povol (enable_irq=1) nebo zake (enable_irq=0) interrupt karty.

function OX952_OpenMulti(inx:DWord; enable_irq:DWord):OX952_RET;          stdcall;
// Oteve danou (inx) kartu pro vcensobn pstup a 
// povol (enable_irq=1) nebo zake (enable_irq=0) interrupt karty.

function OX952_Card_OpenCount(inx:DWord; open_count:PDWord):OX952_RET;    stdcall;
// Zjist poet souasnch oteven funkcemi OX952_Open nebo OX952_OpenMulti.

function OX952_Close(inx:DWord):OX952_RET;                                stdcall;
// Uzave danou (inx) kartu.

function OX952_BAR05_BaseAdr(inx:DWord; base_adr,range:PDWord):OX952_RET; stdcall;
// Zjist pidlenou bzovou adresu a rozsah pamovho prostoru karty.

function OX952_BAR11_BaseAdr(inx:DWord; base_adr,range:PDWord):OX952_RET; stdcall;
// Zjist pidlenou bzovou adresu a rozsah pamovho prostoru karty.

function OX952_IRQ_Wait(inx:DWord; none:PDWord):OX952_RET;                stdcall;
// ek na INT od karty; druh parametr nevyuit.

function OX952_IRQ_Count(inx:DWord):DWord;                                stdcall;
// Vrac poet peruen IRQ.

function OX952_IRQ_SetTimeout(inx:DWord; timeout:DWord):OX952_RET;        stdcall;
// Nastav timeout pro funkci OX952_IRQ_Wait.

procedure OX952_MemWrite(base_adr,offset:DWord; data:Byte);               stdcall;
// Funkce slou pro zpis bytu do pameti. Pouit nalezne
// u jazyk, kter nepodporuj pm pstup k pamti.

function OX952_MemRead(base_adr,offset:DWord):Byte;                       stdcall;
// Funkce slou pro ten bytu z pameti. Pouit nalezne
// u jazyk, kter nepodporuj pm pstup k pamti.



//________________________________________________________________ IMPLEMENTACE

implementation

function  OX952_DriverVersion;      external 'TEDIA_OX952.DLL';
function  OX952_InterfaceVersion;   external 'TEDIA_OX952.DLL';
function  OX952_CardsInSystem;      external 'TEDIA_OX952.DLL';
function  OX952_Card_DID;           external 'TEDIA_OX952.DLL';
function  OX952_Card_BUS;           external 'TEDIA_OX952.DLL';
function  OX952_Card_SLOT;          external 'TEDIA_OX952.DLL';
function  OX952_Open;               external 'TEDIA_OX952.DLL';
function  OX952_OpenMulti;          external 'TEDIA_OX952.DLL';
function  OX952_Card_OpenCount;     external 'TEDIA_OX952.DLL';
function  OX952_Close;              external 'TEDIA_OX952.DLL';
function  OX952_BAR05_BaseAdr;      external 'TEDIA_OX952.DLL';
function  OX952_BAR11_BaseAdr;      external 'TEDIA_OX952.DLL';
function  OX952_IRQ_Wait;           external 'TEDIA_OX952.DLL';
function  OX952_IRQ_Count;          external 'TEDIA_OX952.DLL';
function  OX952_IRQ_SetTimeout;     external 'TEDIA_OX952.DLL';
procedure OX952_MemWrite;           external 'TEDIA_OX952.DLL';
function  OX952_MemRead;            external 'TEDIA_OX952.DLL';

//______________________________________________________________________________

begin
end.


