/*                                  8.8.2012
*                             TEDIA_OX952  v. 3.06
*                         (c) 2012 TEDIA spol. s r. o.
*                             daq_support@tedia.cz
*/




#ifndef __TEDIA_OX952_H
#define __TEDIA_OX952_H

#ifdef  __cplusplus
extern "C" {
#endif


/////////////////////////////////////////////////////////////////////////////////////////////////


#ifdef      BUILD_TEDIA_OX952_DLL
#define     OX952_API      __declspec(dllexport) __stdcall
#else
#define     OX952_API      __declspec(dllimport) __stdcall
#endif

/////////////////////////////////////////////////////////////////////////////////////////////////


#include<windows.h>


typedef		ULONG					OX952_RET;


#define		OX952_Ok				0x00000000
/* #define	OX952_NotRunning			0x00000001 removed in >3.0 */
#define		OX952_BadIndex				0x00000002
#define		OX952_AlreadyOpened		        0x00000004
#define		OX952_CardOpenErr			0x00000008
/* #define	OX952_CardRegisterErr		        0x00000010 removed in >3.0 */
#define		OX952_IntEnableErr			0x00000020
#define		OX952_NotOpened			        0x00000040
#define		OX952_BAR05Err				0x00000080
#define		OX952_IntDisabled			0x00000100
#define		OX952_StopIntThread		        0x00000200
#define		OX952_NullPointer			0x00000400
#define		OX952_CreateEvent			0x00000800
#define		OX952_WaitTimeout			0x00001000
#define         OX952_BAR11Err                          0x00004000
#define         OX952_BAR13Err                          0x00008000
#define		OX952_IntPending			0x00010000
#define		OX952_NoCoupledDevice			0x00020000
#define		OX952_OpenedSameProcess			0x00040000
#define		OX952_VersionConflict			0x80000000



OX952_RET	OX952_API	OX952_DriverVersion (DWORD * ver);

DWORD		OX952_API	OX952_InterfaceVersion (VOID);

OX952_RET	OX952_API	OX952_CardsInSystem (DWORD * count);

OX952_RET	OX952_API	OX952_Card_DID (DWORD inx,DWORD * did);

OX952_RET	OX952_API	OX952_Card_BUS (DWORD inx,DWORD * bus);

OX952_RET	OX952_API	OX952_Card_SLOT (DWORD inx,DWORD * slot);

OX952_RET	OX952_API	OX952_Open (DWORD inx,BOOL enable_int);

OX952_RET	OX952_API	OX952_OpenMulti (DWORD inx,BOOL enable_int);

OX952_RET	OX952_API	OX952_Card_OpenCount(DWORD inx, DWORD *count);

OX952_RET	OX952_API	OX952_Close (DWORD inx);

OX952_RET	OX952_API	OX952_BAR05_BaseAdr (DWORD inx, size_t *base_adr, DWORD *range);

OX952_RET	OX952_API	OX952_BAR11_BaseAdr (DWORD inx, size_t *base_adr, DWORD *range);

OX952_RET	OX952_API	OX952_IRQ_Wait (DWORD inx, DWORD *IrqCount);

DWORD		OX952_API	OX952_IRQ_Count (DWORD inx);

OX952_RET	OX952_API	OX952_IRQ_SetTimeout (DWORD inx,DWORD timeout);

void		OX952_API	OX952_MemWrite (size_t base_adr,DWORD offset,BYTE data);

BYTE		OX952_API	OX952_MemRead (size_t base_adr,DWORD offset);


/////////////////////////////////////////////////////////////////////////////////////////////////////////////


#ifdef __cplusplus
 }
#endif

#endif


