//______________________________________________________________________________
//
//            Hlavikov soubor knihovny TEDIA_OX9162.DLL pro Delphi
//
//                                verze 3.06
//
//                        (c) TEDIA 2012 (8.8.2012)
// 
//                            daq_support@tedia.cz
//
//______________________________________________________________________________
//______________________________________________________________________________
//______________________________________________________________________________

unit tedia_ox9162;

interface
uses Windows;


//______________________________________________________________________________

const

//........................................... nvratov kdy funkc (OX9162_RET)

  OX9162_Ok                = $00000000;
// OX9162_NotRunning       = $00000001; removed in >3.0 
  OX9162_BadIndex          = $00000002;
  OX9162_AlreadyOpened     = $00000004;
  OX9162_CardOpenErr       = $00000008;
// OX9162_CardRegisterErr  = $00000010; removed in >3.0 
  OX9162_IntEnableErr      = $00000020;
  OX9162_NotOpened         = $00000040;
  OX9162_BAR4Err           = $00000080;
  OX9162_IntDisabled       = $00000100;
  OX9162_StopIntThread     = $00000200;
  OX9162_NullPointer       = $00000400;
  OX9162_CreateEvent       = $00000800;
  OX9162_WaitTimeout       = $00001000;
  OX9162_BAR3Err           = $00002000;
  OX9162_IntPending        = $00010000;
  OX9162_OpenedSameProcess = $00040000;
  OX9162_VersionConflict   = $80000000;


//............................................................. DID karet TEDIA

  DID_PCD7004   = $0101;
  DID_PCD7104   = $0102;
  DID_PCT7303A  = $0121;
  DID_PCT7408A  = $0122;
  DID_PCT7424   = $0123;
  DID_PCA7208AL = $0141;
  DID_PCA7208AS = $0142;
  DID_PCA7408AL = $0143;
  DID_PCA7408AS = $0144;
  DID_PCA7228AL = $0145;
  DID_PCA7228AS = $0146;
  DID_PCA7428AL = $0147;
  DID_PCA7428AS = $0148;
  DID_PCA7228EL = $0149;
  DID_PCA7428EL = $0150;
  DID_PCA7628AL = $0151;
  DID_PCA7628AS = $0152;
  DID_PCA7288A  = $0161;
  DID_PCI1052   = $0180;
  DID_ES01      = $8001;
  DID_GPS11     = $8002;
  DID_LAB1052   = $8008; 
  DID_PCI_KIT   = $8101;


type
  OX9162_RET = Cardinal;
  DWord      = Cardinal;
  PWord      = ^Word;
  PDWord     = ^DWord;



//_____________________________________________________________ EXPORTOVAN FCE


function OX9162_DriverVersion(Verze:PDWORD):OX9162_RET;                 stdcall;
// Vrac verzi driveru.

function OX9162_InterfaceVersion:DWord;                                 stdcall;
// Vrac verzi knihovny Tedia_OX9162.

function OX9162_CardsInSystem(PocetKaret:PDWORD):OX9162_RET;            stdcall;
// Vrac poet karet s adiem OX9162.

function OX9162_Card_DID(I_karty:DWord; DID:PDWord):OX9162_RET;         stdcall;
// Vrac DID karty I_karty (0 a PocetKaret-1).

function OX9162_Card_BUS(I_karty:DWord; BUS:PDWord):OX9162_RET;         stdcall;
// Vrac BUS karty I_karty (0 a PocetKaret-1).

function OX9162_Card_SLOT(I_karty:DWord; SLOT:PDWord):OX9162_RET;       stdcall;
// Vrac SLOT karty I_karty (0 a PocetKaret-1).

function OX9162_Open(I_karty:DWord; Pouzij_INT:DWord):OX9162_RET;       stdcall;
// Oteve danou (inx) kartu a
// povol (Pouzij_INT=1) nebo zake (Pouzij_INT=0) interrupt karty.

function OX9162_OpenMulti(I_karty:DWord; Pouzij_INT:DWord):OX9162_RET;  stdcall;
// Oteve danou (inx) kartu pro vcensobn pstup a 
// povol (Pouzij_INT=1) nebo zake (Pouzij_INT=0) interrupt karty.

function OX9162_Card_OpenCount(I_karty:DWord; Pocet_otevreni:PDWord):OX9162_RET;  stdcall;
// Zjist poet souasnch oteven funkcemi OX9162_Open nebo OX9162_OpenMulti.

function OX9162_Close(I_karty:DWord):OX9162_RET;                        stdcall;
// Uzave danou kartu.

function OX9162_BAR4_BaseAdr(I_karty:DWord;Baze,Rozsah:PDWord):OX9162_RET; stdcall;
// Zjist pidlenou bzovou adresu a rozsah pamovho prostoru karty.

function OX9162_IRQ_SetTimeout(I_karty:DWord;Timeout:DWord):OX9162_RET; stdcall;
// Nastav timeout pro funkci OX9162_IRQ_Wait.

function OX9162_IRQ_Wait(I_karty:DWord; none:PDWord):OX9162_RET;        stdcall;
// ek na INT od karty; druh parametr nevyuit.

function OX9162_IRQ_Count(I_karty:DWord):DWord;                         stdcall;
// Vrac poet peruen IRQ.

procedure OX9162_MemWrite(Base_adr,Offset:DWord;Data:byte);             stdcall;
// Funkce slou pro zpis bytu v prostoru BAR4. Pouit nalezne
// u jazyk, kter nepodporuj pm pstup k pamti.

function OX9162_MemRead(Base_adr,Offset:DWord):byte;                    stdcall;
// Funkce slou pro ten bytu v prostoru BAR4. Pouit nalezne
// u jazyk, kter nepodporuj pm pstup k pamti.


//________________________________________________________________ IMPLEMENTACE

implementation

function  OX9162_DriverVersion;      external 'TEDIA_OX9162.DLL';
function  OX9162_InterfaceVersion;   external 'TEDIA_OX9162.DLL';
function  OX9162_CardsInSystem;      external 'TEDIA_OX9162.DLL';
function  OX9162_Card_DID;           external 'TEDIA_OX9162.DLL';
function  OX9162_Card_BUS;           external 'TEDIA_OX9162.DLL';
function  OX9162_Card_SLOT;          external 'TEDIA_OX9162.DLL';
function  OX9162_Open;               external 'TEDIA_OX9162.DLL';
function  OX9162_OpenMulti;          external 'TEDIA_OX9162.DLL';
function  OX9162_Card_OpenCount;     external 'TEDIA_OX9162.DLL';
function  OX9162_Close;              external 'TEDIA_OX9162.DLL';
function  OX9162_BAR4_BaseAdr;       external 'TEDIA_OX9162.DLL';
function  OX9162_IRQ_SetTimeout;     external 'TEDIA_OX9162.DLL';
function  OX9162_IRQ_Wait;           external 'TEDIA_OX9162.DLL';
function  OX9162_IRQ_Count;          external 'TEDIA_OX9162.DLL';
procedure OX9162_MemWrite;           external 'TEDIA_OX9162.DLL';
function  OX9162_MemRead;            external 'TEDIA_OX9162.DLL';

//______________________________________________________________________________

begin
end.


