/*                          8.8.2012
*                       TEDIA_OX9162 v. 3.06
*                   (c) 2012 TEDIA spol. s r. o.
*                       daq_support@tedia.cz
*
*/

#ifndef __TEDIA_OX9162_H
#define __TEDIA_OX9162_H

#ifdef  __cplusplus
extern "C" {
#endif


//////////////////////////////////////////////////////////////////////////////////////////


#ifdef      BUILD_TEDIA_OX9162_DLL
    #define     OX9162_API      __declspec(dllexport) __stdcall
#else
    #define     OX9162_API      __declspec(dllimport) __stdcall
#endif

//////////////////////////////////////////////////////////////////////////////////////////


#include <windows.h>


typedef		ULONG						OX9162_RET;
        
        
#define		OX9162_Ok				0x00000000
/* #define	OX9162_NotRunning			0x00000001 removed in >3.0 */
#define		OX9162_BadIndex				0x00000002
#define		OX9162_AlreadyOpened		        0x00000004
#define		OX9162_CardOpenErr			0x00000008
/* #define	OX9162_CardRegisterErr		        0x00000010 removed in >3.0 */
#define		OX9162_IntEnableErr			0x00000020
#define		OX9162_NotOpened			0x00000040
#define		OX9162_BAR4Err				0x00000080
#define		OX9162_IntDisabled			0x00000100
#define		OX9162_StopIntThread		        0x00000200
#define		OX9162_NullPointer			0x00000400
#define		OX9162_CreateEvent			0x00000800
#define		OX9162_WaitTimeout			0x00001000
#define         OX9162_BAR3Err                          0x00002000
#define		OX9162_IntPending			0x00010000
#define		OX9162_OpenedSameProcess		0x00040000
#define		OX9162_VersionConflict			0x80000000



OX9162_RET	OX9162_API	OX9162_DriverVersion (DWORD * ver);

DWORD		OX9162_API	OX9162_InterfaceVersion (VOID);

OX9162_RET	OX9162_API	OX9162_CardsInSystem (DWORD * count);

OX9162_RET	OX9162_API	OX9162_Card_DID (DWORD inx,DWORD * did);

OX9162_RET	OX9162_API	OX9162_Card_BUS (DWORD inx,DWORD * bus);

OX9162_RET	OX9162_API	OX9162_Card_SLOT (DWORD inx,DWORD * slot);

OX9162_RET	OX9162_API	OX9162_Open (DWORD inx,BOOL enable_int);

OX9162_RET	OX9162_API	OX9162_OpenMulti(DWORD inx, BOOL enable_int);

OX9162_RET	OX9162_API	OX9162_Card_OpenCount(DWORD inx, DWORD *count);

OX9162_RET	OX9162_API	OX9162_Close (DWORD inx);

OX9162_RET	OX9162_API	OX9162_BAR4_BaseAdr (DWORD inx, size_t *base_adr, DWORD *range);

OX9162_RET	OX9162_API	OX9162_IRQ_Wait (DWORD inx,DWORD *);

DWORD		OX9162_API	OX9162_IRQ_Count (DWORD inx);

OX9162_RET	OX9162_API	OX9162_IRQ_SetTimeout (DWORD inx,DWORD timeout);

void		OX9162_API	OX9162_MemWrite (size_t base_adr, DWORD offset, BYTE data);

BYTE		OX9162_API	OX9162_MemRead (size_t base_adr, DWORD offset);


/////////////////////////////////////////////////////////////////////////////////////////////////////////////


#ifdef __cplusplus
 }
#endif

#endif


